<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\StaffAdminController;
use App\Http\Controllers\Admin\BuilderAdminController;
use App\Http\Controllers\Admin\StaffController;
use App\Http\Controllers\Admin\BuilderController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\RecordController;
use App\Http\Controllers\RecordController as Test;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/privacy-policy', [Test::class, 'privacy']);
Auth::routes(['register' => false]);
Route::group(['middleware' => 'auth:web'], function () {
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/admin-update-password', [AdminController::class, 'updatePassword']);
Route::post('/admin-update-password', [AdminController::class, 'updatePassword']);

Route::get('/staff-admins', [StaffAdminController::class, 'index'])->name('staff-admin.index');
Route::post('/add-staff-admin', [StaffAdminController::class, 'store'])->name('staff-admin.store');
Route::get('delete/{id}/staff-admin', [StaffAdminController::class, 'destroy']);
Route::post('staff-admin-status',[StaffAdminController::class, 'changeAdminStatus']);
Route::get('/staff-admin-detail', [StaffAdminController::class, 'detail'])->name('staff-admin.fetchdata');
Route::post('/staff-admin-update', [StaffAdminController::class, 'update'])->name('staff-admin.update');
Route::get('/admin/{id}/staff', [StaffAdminController::class, 'staffList']);
Route::get('staff-admin/{id}/reports', [RecordController::class, 'staffAdminReport']);

Route::get('/builder-admins', [BuilderAdminController::class, 'index'])->name('builder-admin.index');
Route::post('/add-builder-admin', [BuilderAdminController::class, 'store'])->name('builder-admin.store');
Route::get('delete/{id}/builder-admin', [BuilderAdminController::class, 'destroy']);
Route::post('builder-admin-status',[BuilderAdminController::class, 'changeAdminStatus']);
Route::get('/builder-admin-detail', [BuilderAdminController::class, 'detail'])->name('builder-admin.fetchdata');
Route::post('/builder-admin-update', [BuilderAdminController::class, 'update'])->name('builder-admin.update');
Route::get('/admin/{id}/builder', [BuilderAdminController::class, 'builderList']);

Route::get('/staff', [StaffController::class, 'index'])->name('staff.index');
Route::post('staff-status',[StaffController::class, 'changeStaffStatus']);
Route::get('/staff-detail', [StaffController::class, 'detail'])->name('staff.fetchdata');

Route::post('/staff-add', [StaffController::class, 'staffAdd'])->name('staff.store');

Route::post('/staff-update', [StaffController::class, 'update'])->name('staff.update');
Route::get('delete/{id}/staff', [StaffController::class, 'destroy']);
Route::get('staff/{id}/reports', [RecordController::class, 'staffReport']);

Route::get('/builder', [BuilderController::class, 'index'])->name('builder.index');
Route::post('builder-status',[BuilderController::class, 'changeBuilderStatus']);
Route::get('/builder-detail', [BuilderController::class, 'detail'])->name('builder.fetchdata');
Route::post('/builder-save', [BuilderController::class, 'builderSave'])->name('builder.save');
Route::post('/builder-update', [BuilderController::class, 'update'])->name('builder.update');
Route::get('delete/{id}/builder', [BuilderController::class, 'destroy']);
Route::get('builder/{id}/reports', [RecordController::class, 'builderReport']);
Route::get('client/{id}/reports', [RecordController::class, 'clientReport']);

Route::get('/records', [RecordController::class, 'index'])->name('record.index');
Route::post('/save-record', [RecordController::class, 'store']);
Route::post('record-status',[RecordController::class, 'changeRecordStatus']);
Route::get('record/{id}/detail', [RecordController::class, 'detail']);
Route::post('record-image-update/{id}',[RecordController::class, 'updateRecordImage']);
Route::post('record-image-upload/{id}',[RecordController::class, 'uploadRecordImage']);
Route::get('record-image-delete/{id}',[RecordController::class, 'deleteRecordImage']);
Route::post('/delete-record', [RecordController::class, 'deleteMultiple']);
Route::get('location/{id}/reports', [RecordController::class, 'locationReport']);


});
