@extends('layouts.main-layout')

@section('content')
    <!--**********************************
                                        Content body start
                                    ***********************************-->
    <div class="content-body">

        <div class="row page-titles mx-0">
            <div class="col p-md-0">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active"><a href="">Update Password</a></li>
                </ol>
            </div>
        </div>
        <!-- row -->

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                
                    <div class="card">
                        
                        <div class="card-body">
                            <h1 class="card-title" style="text-align: -webkit-center;">Update Password</h1>
                            <form action="{{url('/admin-update-password')}}" method="post" enctype="multipart/form-data">
                                @csrf 
                                <div class="form-group row">
                                    @error('title')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                    <label class="col-lg-12 col-form-label" for="val-disease">Current Password</label>    
                                        <div class="col-lg-12">
                                            <span class="text-danger">@error('currentPassword') {{ $message }} @enderror</span>
                                            <input type="password" name="currentPassword" placeholder="Current Password"  class="form-control" required />
                                        </div>
                                    <label class="col-lg-12 col-form-label" for="val-disease">New Password</label>    
                                        <div class="col-lg-12">
                                            <span class="text-danger">@error('newPassword') {{ $message }} @enderror</span>
                                            <input type="password" name="newPassword" placeholder="New Password" class="form-control"/>
                                        </div>
                                     <label class="col-lg-12 col-form-label" for="val-disease">Confirm Password</label>    
                                        <div class="col-lg-12">
                                            <span class="text-danger">@error('confirmPassword') {{ $message }} @enderror</span>
                                            <input type="password" name="confirmPassword" class="form-control" placeholder="Confirm Password" class="form-control"/></br>
                                        </div>
                                        <div class="col-lg-6">
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>   
                            </form>
                                </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- #/ container -->
    </div>
    </div>

    <!-- #/ container -->
    </div>
    
    <!--**********************************
                                        Content body end
                                    ***********************************-->
    <script>
        $(document).ready(function() {
            toastr.options.timeOut = 10000;
            @if (Session::has('error'))
                toastr.error('{{ Session::get('error') }}');
            @elseif (Session::has('success'))
                toastr.success('{{ Session::get('success') }}');
            @endif
        });
    </script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.0/sweetalert.min.js"></script>
    <script type="text/javascript">
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "preventDuplicates": true,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "1000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
    </script>
@endsection
