@extends('layouts.main-layout')

@section('content')
    <!--**********************************
                                        Content body start
                                    ***********************************-->
    <div class="content-body">

        <div class="row page-titles mx-0">
            <div class="col p-md-0">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active"><a href="">Records</a></li>
                </ol>
            </div>
        </div>
        <!-- row -->

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">


                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <a class="btn mb-1 btn-primary assign-confirm-m" style="margin-left: 30px;color:white;">Delete Multiple</a>
                                <h4 class="card-title" style="text-align: -webkit-center;color: slategrey;">Records List
                                </h4>

                                <table class="table table-striped table-bordered zero-configuration dataTable"
                                    id="example">
                                    <thead>
                                        <tr>
                                            <th>Select</th>
                                            <th>No.</th>
                                            <th>Location</th>
                                            <th>Damage</th>
                                            <th>Staff Name</th>
                                            <th>Builder Name</th>
                                            <th>Date</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $i = 1; ?>
                                        @foreach ($data as $item)
                                            <tr>
                                                <td><input type="checkbox" class="checkbox" data-id="{{$item->id}}"></td>
                                                <td>{{ $i }}</td>
                                                <td><a title="Click To view this Location's Reports" href="{{ url('location') }}/{{ $item->location_id }}/reports" class="btn mb-1 btn-sm btn-success">{{ $item->location }}</a></td>
                                                <td>@if($item->damage!="" || $item->damage!=NULL)<center><img src="{{asset('template/images/icons8-danger-50.png')}}" alt="" style="width:30px;"></center>@endif</td>
                                                <td><a title="Click To view Created Reports" href="{{ url('staff') }}/{{ $item->staff_id }}/reports" class="label mb-1 label-primary">{{ $item->staff_name }}</a></td>
                                                <td><a title="Click To view Assigned Reports" href="{{ url('builder') }}/{{ $item->builder_id }}/reports" class="label mb-1 label-primary">{{ $item->builder_name }}</a></td>
                                                <td>{{ \Carbon\Carbon::parse($item->created_at)->format('m-d-Y') }}
                                                <td>
                                                    @if ($item->status == 1)
                                                        <a title="Click To Inactive/Activate Record" href="javascript:void(0)"
                                                            class="updateRecordStatus btn mb-1 btn-sm btn-success"
                                                            record_id="{{ $item->id }}"
                                                            id="record-{{ $item->id }}">Active</a>
                                                    @else
                                                        <a title="Click To Inactive/Activate Record" href="javascript:void(0)"
                                                            class="updateRecordStatus btn mb-1 btn-sm btn-danger"
                                                            record_id="{{ $item->id }}"
                                                            id="record-{{ $item->id }}">Inactive</a>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a class="btn mb-1 btn-success btn-sm edit" href="{{'/record'}}/{{ $item->id }}/detail"
                                                            href="#">View Detail</a>
                                                </td>
                                            </tr>
                                            <?php $i++; ?>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>Select</th>
                                            <th>No.</th>
                                            <th>Location</th>
                                            <th>Damage</th>
                                            <th>Staff Name</th>
                                            <th>Builder Name</th>
                                            <th>Date</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- #/ container -->
    </div>
    </div>

    <!-- #/ container -->
    </div>

    <!--**********************************
                                        Content body end
                                    ***********************************-->
    <script>
        $(document).ready(function() {
            toastr.options.timeOut = 10000;
            @if (Session::has('error'))
                toastr.error('{{ Session::get('error') }}');
            @elseif (Session::has('success'))
                toastr.success('{{ Session::get('success') }}');
            @endif
        });
    </script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.0/sweetalert.min.js"></script>
    <script type="text/javascript">
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "preventDuplicates": true,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "1000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
    //update Record Status Attruibute status
        $(".updateRecordStatus").click(function() {
            var status = $(this).text();
            var record_id = $(this).attr("record_id");
            $.ajax({
                type: 'post',
                url: "{{ url('record-status') }}",
                data: {
                    status: status,
                    record_id: record_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(resp) {
                    if (resp['status'] == 0) {
                        $("#record-" + record_id).html("Inactive");
                        $("#record-" + record_id).removeClass('btn-success');
                        $("#record-" + record_id).addClass('btn-danger');
                    } else if (resp['status'] == 1) {
                        $("#record-" + record_id).html("Active");
                        $("#record-" + record_id).removeClass('btn-danger');
                        $("#record-" + record_id).addClass('btn-success');
                    }
                },
                error: function() {
                    alert("error");
                }
            });

        });   
        $('.assign-confirm-m').on('click', function(e) {
            var idsArr = [];  
            $(".checkbox:checked").each(function() {  
                idsArr.push($(this).attr('data-id'));
            });  


            if(idsArr.length <=0)  
            {  
                //console.log('empty')
                alert("Please select atleast one record to Update.");  
            }
            else
            {
                console.log(idsArr)
                //var id = $(this).attr("id");
               $.ajax({
                    type:"POST",
                    url: "{{ url('/delete-record') }}",
                    data: {
                        _token: "{{ csrf_token() }}",
                        idsArr:idsArr,
                        
                    },
                    dataType: 'json',
                    success: function(res){
                        console.log(res)
                    
                   // alert("Successfully Updated");
                    toastr.success('Records Removed', 'Hi');
                   
                    window.setTimeout(function(){location.reload()})
                   }
                });
            }
        });
    </script>
@endsection
