<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreStaffAdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        
        if(empty($this->id)) {
            $rules = [
                'username'=>'required',
                'contact'=>'required|unique:staff_admins|unique:staff|unique:builder_admins|unique:builders',
                'email'=>'required|unique:staff_admins|unique:staff|unique:builder_admins|unique:builders',
                'password'=>'required',
            ];
            return $rules;
         }
         else
         {
            $rules = [
                'username'=>'required',
                'contact'=>'required|unique:staff_admins,contact,'.$this->id,
                'email'=>'required|unique:staff_admins,email,'.$this->id,
            ];
            return $rules;
         }
         
    }
}
