<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Staff;
use App\Models\Builder;
use App\Models\BuilderAdmin;
use App\Models\StaffAdmin;
use App\Models\Record;
use DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    
   
     
    public function index()
    {
        $totalStaff = Staff::count();
        $totalBuilder = Builder::count();
        $totalBuilderAdmin = BuilderAdmin::count();
        $totalStaffAdmin = StaffAdmin::count();
        
        //for Year graphs
        $recordings = Record::select(DB::raw("COUNT(*) as count"))
                            ->whereYear('created_at',date('Y'))
                            ->groupBy(DB::raw("Month(created_at)"))
                            ->pluck('count');
        $Months = Record::select(DB::raw("Month(created_at) as month"))
                            ->whereYear('created_at',date('Y'))
                            ->groupBy(DB::raw("Month(created_at)"))
                            ->pluck('month');
        $recordingCounts = array(0,0,0,0,0,0,0,0,0,0,0,0);
        foreach($Months as $index => $month)
        {
            $recordingCounts[$month-1] = $recordings[$index];
        }
        
        return view('home',compact('totalStaff','totalBuilder','totalBuilderAdmin','totalStaffAdmin','recordingCounts'));
    }
}
