<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Staff;
use App\Models\StaffAdmin;
use App\Models\BuilderAdmin;
use App\Models\Builder;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class BuilderAdminController extends Controller
{
    public function clientsList(Request $request)
    {
        $validateUser = Validator::make($request->all(), 
            [
                'id' => 'required',
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
            
        $data = Builder::select('builders.id','builders.name','builders.email','builders.contact','builders.company','builders.location','builder_admins.name as adminName','builder_admins.id as builderAdminID')->join('builder_admins','builder_admins.id','=','builders.admin_id')->where('builders.admin_id',$request->id)->get();
        $finalData = array();
        foreach($data as $test)
        {
            $k['id'] = $test->id;
            $k['name'] = $test->name;
            $k['email'] = $test->email;
            $k['contact'] = $test->contact;
            $k['company'] = $test->company;
            $k['location'] = $test->location;
            $k['adminName'] = $test->adminName;
            $k['builderAdminID'] = $test->builderAdminID;
            $k['date'] = Carbon::parse($test->created_at)->format('d-m-Y');
            $k['time'] = Carbon::parse($test->created_at)->format('h:i A');
            $finalData[] = $k;
        }
        if($finalData == '[]')
        {
            return response()->json([
                'status' => false,
                'message' => 'Empty Data',
                'data'=>$finalData,
            ], 200);    
        }
        return response()->json([
                'status' => true,
                'message' => 'success',
                'data'=>$finalData,
            ], 200);    
    }
    
    public function clientCreate(Request $request)
    {
         $validateUser = Validator::make($request->all(), 
            [
                'builder_admin_id' => 'required|exists:builder_admins,id',
                'name' => 'required',
                'company' => 'required',
                'email' => 'required|unique:staff|unique:staff_admins|unique:builder_admins|unique:builders',
                'contact' => 'required|unique:staff|unique:staff_admins|unique:builder_admins|unique:builders',
                'location' => 'required',
                'password' => 'required',
                'confirm_password' => 'required',
            ]);
        if($validateUser->fails()){
                return response()->json([
                    'status' => false,
                    
                    'message' => $validateUser->errors()->first()
                ], 401);
            }
        if($request->password != $request->confirm_password)
        {
            return response()->json([
                    'status' => false,
                    'message' => 'Password Not Matched',
                    'errors' => "Password Not Matched"
                ], 401);
        }
        $data = new Builder;
        $data->name = $request->name;
        $data->email = $request->email;
        $data->contact = $request->contact;
        $data->company = $request->company;
        $data->location = $request->location;
        $data->password = $request->password;
        $data->admin_id = $request->builder_admin_id;
        $data->status = 0;
        $data->save();
        return response()->json([
                'status' => true,
                'message' => 'success',
                'data'=>'',
            ], 200);
    }
    
}
