<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Staff;
use App\Models\StaffAdmin;
use Session;

class StaffController extends Controller
{
    public function index()
    {
          $staffAdmins = StaffAdmin::where('status','1')->get();
        $data = Staff::select('staff.*','staff_admins.name as adminName','staff_admins.id as staffAdminID')->join('staff_admins','staff_admins.id','=','staff.admin_id')->get();
        return view('admin.staff',compact('data','staffAdmins'));
    }
    
    public function changeStaffStatus(Request $request)
    {
        if($request->ajax())
        {
            $data = $request->all();
            if($data['status']=='Active')
            {
                $status = 0;    
            }else
            {
                $status = 1;
            }
            Staff::where('id',$data['staff_id'])->update(['status'=>$status]);
            return response()->json(['status'=>$status,'staff_id'=>$data['staff_id']]);
        }
    }
    
    public function detail(Request $request)
    {
        $id = $request->input('id');
        $item = Staff::find($id);
        $output = array(
            'name'    =>  $item->name,
            'email'    =>  $item->email,
            'contact'    =>  $item->contact,
            'company'    =>  $item->company,
            'password'    =>  $item->password,
            'locationn'    =>  $item->location,
            'staffId'     =>  $item->id,
            'admin_id'     =>  $item->admin_id
        );
        echo json_encode($output);
    }
    
    public function staffAdd(Request $request)
    {
         $validated = $request->validate([
            'username' => 'required',
            'contact'=>'required|unique:staff_admins|unique:staff|unique:builder_admins|unique:builders',
            'email'=>'required|unique:staff_admins|unique:staff|unique:builder_admins|unique:builders',
            'password' => 'required',
            'company' => 'required',
            'location' => 'required',
            'staffAdminid' => 'required',
        ]);
        
        $data = new Staff;
        $data->name = $request->input('username');
        $data->contact = $request->input('contact');
        $data->email = $request->input('email');
        $data->company = $request->input('company');
        $data->location = $request->input('location');
        $data->admin_id = $request->input('staffAdminid');
        $data->password = $request->input('password');
        $data->save();
        return response()->json(['success' => true]);
        
    }
    
    public function update(Request $request)
    {
        $game = $request->all();
        $data = Staff::find($request->id);
        $data->name = $request->input('username');
        $data->contact = $request->input('contact');
        $data->email = $request->input('email');
        $data->password = $request->input('password');
        $data->company = $request->input('company');
        $data->location = $request->input('location');
        $data->admin_id = $request->input('AdminId');
        $data->save();
        return response()->json(['success' => true, 'error'=>$game]);
        
    }
    
    public function destroy(Request $request,$id)
    {
        Staff::find($id)->delete();
        Session::flash('error', 'Staff Removed');
        return back();
    }
    
}
