<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\StaffAdmin;
use App\Models\Staff;
use App\Http\Requests\StoreStaffAdminRequest;
use Session;

class StaffAdminController extends Controller
{
    public function index()
    {
        $data = StaffAdmin::get();
        return view('admin.staff_admins',compact('data'));
    }

    public function store(StoreStaffAdminRequest $request)
    {
        try {

            $data = new StaffAdmin;
            $data->name = $request->input('username');
            $data->contact = $request->input('contact');
            $data->email = $request->input('email');
            $data->password = $request->input('password');
            $data->save();
            return response()->json(['success' => true, 'error'=>false]);
          
          } catch (\Exception $e) {
          
              $error = $e->getMessage();
             
                return response()->json(['success' => true, 'error'=>$error]);
          }
        
    }

    public function destroy(Request $request,$id)
    {
        StaffAdmin::find($id)->delete();
        Session::flash('error', 'Staff Admin Removed');
        return back();
    }
    
    public function changeAdminStatus(Request $request)
    {
        if($request->ajax())
        {
            $data = $request->all();
            if($data['status']=='Active')
            {
                $status = 0;    
            }else
            {
                $status = 1;
            }
            StaffAdmin::where('id',$data['staff_admin_id'])->update(['status'=>$status]);
            return response()->json(['status'=>$status,'staff_admin_id'=>$data['staff_admin_id']]);
        }
    }

    public function detail(Request $request)
    {
        $id = $request->input('id');
        $item = StaffAdmin::find($id);
        $output = array(
            'name'    =>  $item->name,
            'email'    =>  $item->email,
            'contact'    =>  $item->contact,
            'password'    =>  $item->password,
            'staffAdminId'     =>  $item->id
        );
        echo json_encode($output);
    }

    public function update(StoreStaffAdminRequest $request)
    {
        //return $request->all();
        $data = StaffAdmin::find($request->id);
        $data->name = $request->input('username');
        $data->contact = $request->input('contact');
        $data->email = $request->input('email');
        $data->password = $request->input('password');
        $data->save();
        return response()->json(['success' => true, 'error'=>false]);
    }
    
    public function staffList(Request $request,$id)
    {
      
        $data = Staff::select('staff.*','staff_admins.name as adminName','staff_admins.id as staffAdminID')->join('staff_admins','staff_admins.id','=','staff.admin_id')->where('staff.admin_id',$id)->get();
        return view('admin.staff',compact('data'));
    }

}
