<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BuilderAdmin;
use App\Models\Builder;
use App\Http\Requests\StoreBuilderAdminRequest;
use Session;

class BuilderAdminController extends Controller
{
    public function index()
    {
        $data = BuilderAdmin::get();
        return view('admin.builder_admins',compact('data'));
    }

    public function store(StoreBuilderAdminRequest $request)
    {
        try {

            $data = new BuilderAdmin;
            $data->name = $request->input('username');
            $data->contact = $request->input('contact');
            $data->email = $request->input('email');
            $data->password = $request->input('password');
            $data->location = $request->input('location');
            $data->company = "Allscape";
            $data->save();
            return response()->json(['success' => true, 'error'=>false]);
          
          } catch (\Exception $e) {
          
              $error = $e->getMessage();
             
                return response()->json(['success' => true, 'error'=>$error]);
          }
        
    }

    public function destroy(Request $request,$id)
    {
        BuilderAdmin::find($id)->delete();
        Session::flash('error', 'Builder Admin Removed');
        return back();
    }
    
    public function changeAdminStatus(Request $request)
    {
        if($request->ajax())
        {
            $data = $request->all();
            if($data['status']=='Active')
            {
                $status = 0;    
            }else
            {
                $status = 1;
            }
            BuilderAdmin::where('id',$data['builder_admin_id'])->update(['status'=>$status]);
            return response()->json(['status'=>$status,'builder_admin_id'=>$data['builder_admin_id']]);
        }
    }

    public function detail(Request $request)
    {
        $id = $request->input('id');
        $item = BuilderAdmin::find($id);
        $output = array(
            'name'    =>  $item->name,
            'email'    =>  $item->email,
            'contact'    =>  $item->contact,
            'builderAdminId'     =>  $item->id,
            'password'     =>  $item->password,
            'locationd'     =>  $item->location
        );
        echo json_encode($output);
    }

    public function update(StoreBuilderAdminRequest $request)
    {
        //return $request->all();
        $data = BuilderAdmin::find($request->id);
        $data->name = $request->input('username');
        $data->contact = $request->input('contact');
        $data->email = $request->input('email');
        $data->password = $request->input('password');
        $data->location = $request->input('location');
        $data->save();
        return response()->json(['success' => true, 'error'=>false]);
    }
    
    public function builderList(Request $request,$id)
    {
        $data = Builder::select('builders.*','builder_admins.name as adminName','builder_admins.id as builderAdminID')->join('builder_admins','builder_admins.id','=','builders.admin_id')->where('builders.admin_id',$id)->get();
        return view('admin.builder',compact('data'));
    }
}
