<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Auth;
use Hash;
use Session;

class AdminController extends Controller
{
    public function updatePassword(Request $request)
    {
        if($request->isMethod('post'))
        {
            $request->validate([
            'currentPassword'=>'required',
            'newPassword'=>'required|min:6',
            'confirmPassword'=>'required|min:6|same:newPassword',
            ]);
            $id = Auth::id();
            $checkAdmin = User::where('id',$id)->first();
            if (Hash::check($request->input('currentPassword'), $checkAdmin->password)) 
            {
                if($request->input('newPassword') === $request->input('confirmPassword'))
                {
                    User::where('id',$id)->update([
                        'password'=>Hash::make($request->input('newPassword'))
                        ]);
                    Session::flash('success', 'Password Updated');
                    return back();    
                }
                else
                {
                    Session::flash('error', 'New And Confirm Password Not Matched');
                    return back();
                }
            }
            else
            {
                Session::flash('error', 'Current Password Not Matched');
                return back();
            }
        }
        return view('admin.update-password');
    }
}
